package ru.yandex.partner.jsonapi.crnk.page.authorization;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.jsonapi.crnk.page.PageRightsEnum;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.rbac.role.RoleSet;

@Component
public class PageViewAllRule {

    public <P extends BasePage> AuthorizationDecision<P> authorize(String modelName, UserAuthentication ua) {
        String rightName = PageRightsEnum.VIEW_ALL.getFullRightName(modelName);
        return (ua.userHasRight(rightName) && !ua.userHasRole(RoleSet.ROBOT_ASSISTANT))
                ? AuthorizationDecision.permit()
                : AuthorizationDecision.unapplicable();
    }
}
