package ru.yandex.partner.jsonapi.crnk.page.authorization.actions;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.AbstractActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionAuthEntry;
import ru.yandex.partner.jsonapi.models.page.internal.ApiInternalContextPageMetaData;
import ru.yandex.partner.libs.auth.facade.UserAuthenticationProvider;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Component
@ParametersAreNonnullByDefault
public class InternalContextPageActionsAuthorizationService
        extends AbstractActionsAuthorizationService<InternalContextPage> {

    protected InternalContextPageActionsAuthorizationService(
            @Nullable MultistateGraph<? super InternalContextPage, ?> graph,
            ApiInternalContextPageMetaData apiInternalContextPageMetaData,
            UserAuthenticationProvider authenticationFacade,
            List<ModelProperty<? super InternalContextPage, ?>> requiredProperties) {
        super(graph, apiInternalContextPageMetaData, authenticationFacade, requiredProperties);
    }


    @Override
    protected Map<String, ActionAuthEntry<InternalContextPage>> getAuthEntryMap() {
        // TODO
        throw new NotImplementedException("Not implemented yet");
    }
}
