package ru.yandex.partner.jsonapi.crnk.page.authorization.actions;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.AbstractActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionAuthEntry;
import ru.yandex.partner.jsonapi.models.page.mobile.internal.ApiInternalMobileAppMetaData;
import ru.yandex.partner.libs.auth.facade.UserAuthenticationProvider;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Component
@ParametersAreNonnullByDefault
public class InternalMobileAppActionsAuthorizationService
        extends AbstractActionsAuthorizationService<InternalMobileApp> {

    protected InternalMobileAppActionsAuthorizationService(
            @Nullable MultistateGraph<? super InternalMobileApp, ?> graph,
            ApiInternalMobileAppMetaData apiInternalMobileAppMetaData,
            UserAuthenticationProvider authenticationFacade,
            List<ModelProperty<? super InternalMobileApp, ?>> requiredProperties) {
        super(graph, apiInternalMobileAppMetaData, authenticationFacade, requiredProperties);
    }


    @Override
    protected Map<String, ActionAuthEntry<InternalMobileApp>> getAuthEntryMap() {
        // TODO
        throw new NotImplementedException("Not implemented yet");
    }
}
