package ru.yandex.partner.jsonapi.crnk.page.authorization.actions;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.AbstractActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionAuthEntry;
import ru.yandex.partner.jsonapi.models.page.mobile.external.ApiMobileAppSettingsMetaData;
import ru.yandex.partner.libs.auth.facade.UserAuthenticationProvider;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Component
@ParametersAreNonnullByDefault
public class MobileAppSettingsActionsAuthorizationService
        extends AbstractActionsAuthorizationService<MobileAppSettings> {

    @Autowired
    protected MobileAppSettingsActionsAuthorizationService(
            @Nullable MultistateGraph<? super MobileAppSettings, ?> graph,
            ApiMobileAppSettingsMetaData apiModelMetaData,
            UserAuthenticationProvider authenticationFacade,
            List<ModelProperty<? super MobileAppSettings, ?>> requiredProperties) {
        super(graph, apiModelMetaData, authenticationFacade, requiredProperties);
    }

    @Override
    protected Map<String, ActionAuthEntry<MobileAppSettings>> getAuthEntryMap() {
        // TODO
        throw new NotImplementedException("Not implemented yet");
    }
}
