package ru.yandex.partner.jsonapi.crnk.page.models;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.user.models.PageOwnerCrnk;

public class ContextPageForBlockCrnk {
    @JsonProperty(PageCrnkJsonFieldAliases.ID)
    private String id;

    @JsonProperty(PageCrnkJsonFieldAliases.PAGE_ID)
    private Long pageId;

    @JsonProperty(PageCrnkJsonFieldAliases.CAPTION)
    private String caption;

    @JsonProperty(PageCrnkJsonFieldAliases.OWNER_ID)
    private Long ownerId;

    @JsonProperty(PageCrnkJsonFieldAliases.DOMAIN_ID)
    private Long domainId;

    @JsonProperty(PageCrnkJsonFieldAliases.DOMAIN)
    private String domain;

    @JsonProperty(PageCrnkJsonFieldAliases.ALLOWED_AMP)
    private Boolean allowedAmp;

    @JsonProperty(PageCrnkJsonFieldAliases.ALLOWED_TURBO)
    private Boolean allowedTurbo;

    @JsonProperty(PageCrnkJsonFieldAliases.MULTISTATE)
    private Long multistate;

    @JsonProperty(PageCrnkJsonFieldAliases.UNMODERATED_RTB_AUCTION)
    private Boolean unmoderatedRtbAuction;

    @JsonProperty(PageCrnkJsonFieldAliases.CUR_USER_IS_READ_ASSISTANT)
    private Boolean curUserIsReadAssistant;

    @JsonProperty(PageCrnkJsonFieldAliases.LOGIN)
    private String login;

    @JsonProperty(PageCrnkJsonFieldAliases.OWNER)
    private PageOwnerCrnk owner;

    @JsonProperty(PageCrnkJsonFieldAliases.BLOCKS_COUNT)
    private Long blocksCount;

    @JsonProperty(PageCrnkJsonFieldAliases.BLOCKS_LIMIT)
    private Long blocksLimit;

    @JsonProperty(PageCrnkJsonFieldAliases.IS_PROTECTED)
    private Boolean isProtected;

    @JsonIgnore
    private List<Assistant> assistants;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getDomainId() {
        return domainId;
    }

    public void setDomainId(Long domainId) {
        this.domainId = domainId;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Boolean getAllowedAmp() {
        return allowedAmp;
    }

    public void setAllowedAmp(Boolean allowedAmp) {
        this.allowedAmp = allowedAmp;
    }

    public Boolean getAllowedTurbo() {
        return allowedTurbo;
    }

    public void setAllowedTurbo(Boolean allowedTurbo) {
        this.allowedTurbo = allowedTurbo;
    }

    public Long getMultistate() {
        return multistate;
    }

    public void setMultistate(Long multistate) {
        this.multistate = multistate;
    }

    public Boolean getUnmoderatedRtbAuction() {
        return unmoderatedRtbAuction;
    }

    public void setUnmoderatedRtbAuction(Boolean unmoderatedRtbAuction) {
        this.unmoderatedRtbAuction = unmoderatedRtbAuction;
    }

    public Boolean getCurUserIsReadAssistant() {
        return curUserIsReadAssistant;
    }

    public void setCurUserIsReadAssistant(Boolean curUserIsReadAssistant) {
        this.curUserIsReadAssistant = curUserIsReadAssistant;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public PageOwnerCrnk getOwner() {
        return owner;
    }

    public void setOwner(PageOwnerCrnk owner) {
        this.owner = owner;
    }

    public Long getBlocksCount() {
        return blocksCount;
    }

    public void setBlocksCount(Long blocksCount) {
        this.blocksCount = blocksCount;
    }

    public Long getBlocksLimit() {
        return blocksLimit;
    }

    public void setBlocksLimit(Long blocksLimit) {
        this.blocksLimit = blocksLimit;
    }

    public Boolean getIsProtected() {
        return isProtected;
    }

    public void setIsProtected(Boolean aProtected) {
        isProtected = aProtected;
    }

    public List<Assistant> getAssistants() {
        return assistants;
    }

    public void setAssistants(List<Assistant> assistants) {
        this.assistants = assistants;
    }
}
