package ru.yandex.partner.jsonapi.crnk.page.models;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.user.models.PageOwnerCrnk;

public class InternalContextPageForBlockCrnk {
    @JsonProperty(PageCrnkJsonFieldAliases.ID)
    private String id;

    @JsonProperty(PageCrnkJsonFieldAliases.CAPTION)
    private String caption;

    @JsonProperty(PageCrnkJsonFieldAliases.OWNER_ID)
    private Long ownerId;

    @JsonProperty(PageCrnkJsonFieldAliases.SITE_ID)
    private Long siteId;

    @JsonProperty(PageCrnkJsonFieldAliases.DOMAIN)
    private String domain;

    @JsonProperty(PageCrnkJsonFieldAliases.ALLOWED_TURBO)
    private Boolean allowedTurbo;

    @JsonProperty(PageCrnkJsonFieldAliases.MULTISTATE)
    private Long multistate;

    @JsonProperty(PageCrnkJsonFieldAliases.UNMODERATED_RTB_AUCTION)
    private Boolean unmoderatedRtbAuction;

    @JsonProperty(PageCrnkJsonFieldAliases.OWNER)
    private PageOwnerCrnk owner;

    @JsonProperty(PageCrnkJsonFieldAliases.IS_PROTECTED)
    private Boolean isProtected;

    @JsonProperty(PageCrnkJsonFieldAliases.IS_MY)
    private Boolean isMy;

    @JsonProperty(PageCrnkJsonFieldAliases.BLOCKS_LIMIT)
    private Long blocksLimit;

    @JsonProperty(PageCrnkJsonFieldAliases.BLOCKS_COUNT)
    private Long blocksCount;

    @JsonIgnore
    private List<Assistant> assistants;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getSiteId() {
        return siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Boolean getAllowedTurbo() {
        return allowedTurbo;
    }

    public void setAllowedTurbo(Boolean allowedTurbo) {
        this.allowedTurbo = allowedTurbo;
    }

    public Long getMultistate() {
        return multistate;
    }

    public void setMultistate(Long multistate) {
        this.multistate = multistate;
    }

    public Boolean getUnmoderatedRtbAuction() {
        return unmoderatedRtbAuction;
    }

    public void setUnmoderatedRtbAuction(Boolean unmoderatedRtbAuction) {
        this.unmoderatedRtbAuction = unmoderatedRtbAuction;
    }

    public PageOwnerCrnk getOwner() {
        return owner;
    }

    public void setOwner(PageOwnerCrnk owner) {
        this.owner = owner;
    }

    public Boolean getIsProtected() {
        return isProtected;
    }

    public void setIsProtected(Boolean aProtected) {
        isProtected = aProtected;
    }

    public Boolean getIsMy() {
        return isMy;
    }

    public void setIsMy(Boolean my) {
        isMy = my;
    }

    public List<Assistant> getAssistants() {
        return assistants;
    }

    public void setAssistants(List<Assistant> assistants) {
        this.assistants = assistants;
    }

    public Long getBlocksLimit() {
        return blocksLimit;
    }

    public void setBlocksLimit(Long blocksLimit) {
        this.blocksLimit = blocksLimit;
    }

    public Long getBlocksCount() {
        return blocksCount;
    }

    public void setBlocksCount(Long blocksCount) {
        this.blocksCount = blocksCount;
    }
}
