package ru.yandex.partner.jsonapi.crnk.user;

import javax.annotation.ParametersAreNonnullByDefault;

import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.adfox.model.AdfoxInfo;
import ru.yandex.partner.jsonapi.crnk.user.models.AdfoxInfoCrnk;


@ParametersAreNonnullByDefault
@Mapper(
        componentModel = "spring", unmappedTargetPolicy = ReportingPolicy.IGNORE)
@Component
public abstract class AdfoxInfoCrnkMapper {

    @Mapping(source = "createDate", target = "createDate", dateFormat = "yyyy-MM-dd HH:mm:ss")
    public abstract AdfoxInfoCrnk adfoxInfoToAdfoxInfoCrnk(AdfoxInfo adfoxInfo);

    @Mapping(source = "createDate", target = "createDate", dateFormat = "yyyy-MM-dd HH:mm:ss")
    public abstract AdfoxInfo adfoxInfoCrnkToAdfoxInfo(AdfoxInfoCrnk adfoxInfo);
}
