package ru.yandex.partner.jsonapi.crnk.user;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.service.validation.type.UserValidationTypeSupportFacade;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ForeignFieldDefaultsService;
import ru.yandex.partner.jsonapi.models.CommonFunctionComposite;
import ru.yandex.partner.jsonapi.models.user.ApiUserModel;

import static ru.yandex.partner.core.entity.user.model.prop.BaseUserIdPropHolder.ID;

@Service
public class UserApiFieldsService extends ApiFieldsService<User> {

    private final UserValidationTypeSupportFacade userValidationTypeSupportFacade;

    @Autowired
    public UserApiFieldsService(ApiUserModel apiUserModel,
                                List<ForeignFieldDefaultsService<User>> foreignFieldDefaultsServiceList,
                                UserValidationTypeSupportFacade userValidationTypeSupportFacade) {
        super(apiUserModel.getApiFieldsAvailableRules(), apiUserModel.getApiFieldsEditableRules(), apiUserModel,
                CrnkConstants.AVAILABLE_FIELDS_FIELD_NAME,
                CrnkConstants.EDITABLE_FIELDS_FIELD_NAME,
                new CommonFunctionComposite<>(),
                foreignFieldDefaultsServiceList
        );
        this.userValidationTypeSupportFacade = userValidationTypeSupportFacade;
    }

    @Override
    public ModelProperty<? super User, ?> getId() {
        return ID;
    }

    @Override
    public Set<ModelProperty<?, ?>> getPropertiesForValidate(Set<ModelProperty<?, ?>> affectedFields) {
        return userValidationTypeSupportFacade.getPropertiesForValidate(
                affectedFields,
                getApiModel().getModelClass()
        );
    }
}
