package ru.yandex.partner.jsonapi.crnk.user;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilterName;
import ru.yandex.partner.jsonapi.models.ApiModel;

@Service
public class UserCrnkModelFilters implements CrnkModelFilters<User> {

    private final ApiModel<User> apiModel;

    @Autowired
    @SuppressWarnings("ParameterNumber")
    public UserCrnkModelFilters(ApiModel<User> apiModel) {
        this.apiModel = apiModel;
    }

    @Override
    public Map<String, CrnkFilter<User, ?>> getFilters() {
        return apiModel.getFilters();
    }


    public enum NameEnum implements CrnkFilterName {
        CLIENT_ID("client_id");

        private final String name;

        NameEnum(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return name;
        }
    }
}
