package ru.yandex.partner.jsonapi.crnk.user;

import ru.yandex.partner.libs.auth.RightHolder;
import ru.yandex.partner.libs.auth.service.UserDetailsService;

public enum UserRightsEnum implements RightHolder {
    VIEW("users_view"),
    VIEW_ADFOX_FIELDS(UserDetailsService.CAN_VIEW_ADFOX_FIELDS),
    VIEW_ACTIVE_CONTRACT_REWARD_TYPE("view_active_contract_reward_type"),

    VIEW_ALL("users_view_all"),
    VIEW_ALL_FIELDS("users_view_all_fields"),
    VIEW_FIELD__USER_ID("users_view_field__user_id"),
    VIEW_FIELD__ID("users_view_field__id"),
    VIEW_FIELD__CLENT_ID("users_view_field__client_id"),
    VIEW_FIELD__EMAIL("users_view_field__email"),
    VIEW_FIELD__HAS_MOBILE_MEDIATION("users_view_field__has_mobile_mediation"),
    VIEW_FIELD__HAS_RSYA("users_view_field__has_rsya"),
    VIEW_FIELD__HAS_TUTBY_AGREEMENT("users_view_field__has_tutby_agreement"),
    VIEW_FIELD__IS_DM_LITE("users_view_field__is_dm_lite"),
    VIEW_FIELD__IS_EFIR_BLOGGER("users_view_field__is_efir_blogger"),
    VIEW_FIELD__IS_GAMES("users_view_field__is_games"),
    VIEW_FIELD__IS_MOBILE_MEDIATION("users_view_field__is_mobile_mediation"),
    VIEW_FIELD__IS_TUTBY("users_view_field__is_tutby"),
    VIEW_FIELD__IS_VIDEO_BLOGGER("users_view_field__is_video_blogger"),
    VIEW_FIELD__MULTISTATE("users_view_field__multistate"),
    VIEW_FIELD__ROLES("users_view_field__roles"),
    VIEW_FIELD__CONTRACT_ID("view_field__contract_id"),
    VIEW_FIELD__MODERATION_REASON("users_view_field__moderation_reason"),
    VIEW_ALL_TUTBY_PARTNERS("users_view_all_tutby_partners"),

    VIEW_SEARCH_FILTERS__USER_TYPE("view_search_filters__user_type"),
    VIEW_SEARCH_FILTERS__LOGIN("view_search_filters__login"),
    VIEW_SEARCH_FILTERS__CLIENT_ID("view_search_filters__client_id"),
    VIEW_SEARCH_FILTERS__APP_ID("view_search_filters__app_id"),


    IS_ASSISTANT("is_assistant"),

    EDIT_ALL("users_edit_all"),
    EDIT_FIELD__FEATURES("users_edit_field__features"),
    EDIT_FIELD__ADFOX_OFFER("users_edit_field__adfox_offer"),
    EDIT_FIELD__ALLOWED_DESIGN_AUCTION_NATIVE_ONLY("users_edit_field__allowed_design_auction_native_only"),
    EDIT_FIELD__CLIENT_ID("users_edit_field__client_id"),
    EDIT_FIELD__IS_TUTBY("users_edit_field__is_tutby"),
    EDIT_FIELD__HAS_GAME_OFFER("users_edit_field__has_game_offer"),
    EDIT_FIELD__HAS_TUTBY_AGREEMENT("users_edit_field__has_tutby_agreement"),
    EDIT_FIELD__CONTENT_BLOCK_EDIT_TEMPLATE_ALLOWED("users_edit_field__content_block_edit_template_allowed"),
    EDIT_FIELD__IS_DM_LITE("users_edit_field__is_dm_lite"),
    EDIT_FIELD__IS_EFIR_BLOGGER("users_edit_field__is_efir_blogger"),
    EDIT_FIELD__IS_GAMES("users_edit_field__is_games"),
    EDIT_FIELD__IS_MOBILE_MEDIATION("users_edit_field__is_mobile_mediation"),
    EDIT_FIELD__MODERATION_REASON("users_edit_field__moderation_reason"),
    EDIT_FIELD__IS_VIDEO_BLOGGER("users_edit_field__is_video_blogger"),

    DO_USER_ACTION_SET_USER_ROLE("do_user_action_set_user_role"),
    DO_USER_ACTION_REVOKE_ROLES("do_user_action_revoke_roles"),
    DO_CONTEXT_ON_SITE_ADD("do_context_on_site_add"),
    DO_SEARCH_ON_SITE_ADD("do_search_on_site_add"),
    DO_MOBILE_APP_ADD("do_mobile_app_add"),

    PARTNER_ACTS_VIEW_FILTER__LOGIN("partner_acts_view_filter__login"),

    MODERATION_REASON_MANAGER_TXT_VIEW("moderation_reason_manager_txt_view");

    private final String rightName;

    UserRightsEnum(String rightName) {
        this.rightName = rightName;
    }

    @Override
    public String getRightName() {
        return rightName;
    }
}
