package ru.yandex.partner.jsonapi.crnk.user.authorization;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

public class ActionAddRule<T> {
    private CheckRightRule<T> checkRightRule;

    private ActionAddRule(Builder<T> builder) {
        this.checkRightRule = builder
                .checkRightRuleFactoryBuilder
                .right("do_" + builder.prefix + "_action_add")
                .build();
    }

    public AuthorizationDecision<T> authorize(UserAuthentication ua) {
        return checkRightRule.authorize(ua);
    }

    @Component
    @Scope("prototype")
    public static final class Builder<T> {
        private String prefix;
        private CheckRightRule.Builder<T> checkRightRuleFactoryBuilder;

        @Autowired
        public Builder(CheckRightRule.Builder<T> checkRightRuleFactoryBuilder) {
            this.checkRightRuleFactoryBuilder = checkRightRuleFactoryBuilder;
        }

        public ActionAddRule.Builder<T> prefix(String val) {
            prefix = val;
            return this;
        }

        public ActionAddRule<T> build() {
            return new ActionAddRule<T>(this);
        }
    }
}
