package ru.yandex.partner.jsonapi.crnk.user.authorization;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

import static ru.yandex.partner.libs.rbac.group.Group.GROUP_YNDX_SERVICES;
import static ru.yandex.partner.libs.rbac.role.RoleService.hasRolesFromGroup;

@Component
public class AdinsideRule {

    private static final CoreFilterNode<User> SUBSET =
            CoreFilterNode.create(UserFilters.ID,
                    FilterOperator.EQUALS,
                    CoreConstants.ADINSIDE_USER_ID);

    public AuthorizationDecision<User> authorize(UserAuthentication ua) {
        if (hasRolesFromGroup(ua.getRoles(), GROUP_YNDX_SERVICES)) {
            return AuthorizationDecision.restrictedPermit(SUBSET);
        } else {
            return AuthorizationDecision.unapplicable();
        }
    }
}
