package ru.yandex.partner.jsonapi.crnk.user.authorization;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.rbac.right.RightService;

public class CheckRightRule<T> {
    private final String right;
    private final RightService rightService;

    private CheckRightRule(Builder<T> builder) {
        this.right = builder.right;
        this.rightService = builder.rightService;
    }

    public AuthorizationDecision<T> authorize(UserAuthentication ua) {
        boolean hasRight = rightService.isRightExists(right) && ua.userHasRight(right);
        if (hasRight) {
            return AuthorizationDecision.permit();
        } else {
            return AuthorizationDecision.unapplicable();
        }
    }

    @Component
    @Scope("prototype")
    public static final class Builder<T> {
        private String right;
        private RightService rightService;

        @Autowired
        public Builder(RightService rightService) {
            this.rightService = rightService;
        }

        public Builder<T> right(String val) {
            right = val;
            return this;
        }

        public CheckRightRule<T> build() {
            return new CheckRightRule<>(this);
        }
    }
}
