package ru.yandex.partner.jsonapi.crnk.user.authorization;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

public class EditAllRule<T> {
    private CheckRightRule<T> checkRightRule;

    private EditAllRule(Builder<T> builder) {
        this.checkRightRule = builder.checkRightRuleFactoryBuilder.right(builder.prefix + "_edit_all").build();
    }

    public AuthorizationDecision<T> authorize(UserAuthentication ua) {
        return checkRightRule.authorize(ua);
    }

    @Component
    @Scope("prototype")
    public static final class Builder<T> {
        private String prefix;
        private CheckRightRule.Builder<T> checkRightRuleFactoryBuilder;

        @Autowired
        public Builder(CheckRightRule.Builder<T> checkRightRuleFactoryBuilder) {
            this.checkRightRuleFactoryBuilder = checkRightRuleFactoryBuilder;
        }

        public Builder<T> prefix(String val) {
            prefix = val;
            return this;
        }

        public EditAllRule<T> build() {
            return new EditAllRule<T>(this);
        }
    }
}
