package ru.yandex.partner.jsonapi.crnk.user.authorization;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.assistant.filter.AssistantFilters;
import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Component
public class OwnersForAssistantRule {
    private final CheckRightRule<User> checkRightRule;

    @Autowired
    public OwnersForAssistantRule(CheckRightRule.Builder<User> checkRightRuleBuilder) {
        this.checkRightRule = checkRightRuleBuilder.right("is_assistant").build();
    }

    public AuthorizationDecision<User> authorize(UserAuthentication ua) {
        AuthorizationDecision<User> decision = checkRightRule.authorize(ua);
        if (decision.isPermitted()) {
            CoreFilterNode<Assistant> pageAssistantCoreFilter = CoreFilterNode.create(
                    AssistantFilters.USER_ID,
                    FilterOperator.IN,
                    ua.getUid()
            );

            CoreFilterNode<BasePage> pageCoreFilter = CoreFilterNode.create(
                    PageFilters.ASSISTANTS,
                    FilterOperator.MATCH,
                    pageAssistantCoreFilter
            );

            CoreFilterNode<User> subset = CoreFilterNode.create(
                    UserFilters.PAGE,
                    FilterOperator.MATCH,
                    pageCoreFilter
            );

            return AuthorizationDecision.restrictedPermit(subset);
        } else {
            return AuthorizationDecision.unapplicable();
        }
    }
}
