package ru.yandex.partner.jsonapi.crnk.user.authorization;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Component
public class SelfAccessRule {
    public AuthorizationDecision<User> authorize(UserAuthentication ua) {
        CoreFilterNode<User> subset =
                CoreFilterNode.create(
                        UserFilters.UID,
                        FilterOperator.EQUALS,
                        ua.getUid()
                );
        return AuthorizationDecision.restrictedPermit(subset);
    }

    public AuthorizationDecision<User> authorize(UserAuthentication ua, User accessedUser) {
        if (accessedUser.getUid().equals(ua.getUid())) {
            return AuthorizationDecision.permit();
        } else {
            return AuthorizationDecision.unapplicable();
        }
    }
}
