package ru.yandex.partner.jsonapi.crnk.user.authorization;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.jsonapi.crnk.user.UserRightsEnum;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Component
public class TutbyRule {
    private CheckRightRule<User> checkRightRule;

    @Autowired
    public TutbyRule(CheckRightRule.Builder<User> checkRightRuleBuilder) {
        this.checkRightRule =
                checkRightRuleBuilder.right(UserRightsEnum.VIEW_ALL_TUTBY_PARTNERS.getRightName()).build();
    }

    public AuthorizationDecision<User> authorize(UserAuthentication ua) {
        AuthorizationDecision<User> decision = checkRightRule.authorize(ua);
        if (decision.isPermitted()) {
            CoreFilterNode<User> subset =
                    CoreFilterNode.create(
                            UserFilters.IS_TUTBY,
                            FilterOperator.EQUALS,
                            true
                    );

            return AuthorizationDecision.restrictedPermit(subset);
        } else {
            return AuthorizationDecision.unapplicable();
        }
    }
}
