package ru.yandex.partner.jsonapi.crnk.user.authorization;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.entity.user.model.User;

@Configuration
public class UserAuthorizationRuleConfiguration {

    private static final String PREFIX = "users";

    ActionAddRule.Builder<User> actionAddRuleBuilder;
    EditAllRule.Builder<User> editAllRuleBuilder;
    ViewAllRule.Builder<User> viewAllRuleBuilder;

    @Autowired
    public UserAuthorizationRuleConfiguration(ActionAddRule.Builder<User> actionAddRuleBuilder,
                                              EditAllRule.Builder<User> editAllRuleBuilder,
                                              ViewAllRule.Builder<User> viewAllRuleBuilder) {
        this.actionAddRuleBuilder = actionAddRuleBuilder;
        this.editAllRuleBuilder = editAllRuleBuilder;
        this.viewAllRuleBuilder = viewAllRuleBuilder;
    }

    @Bean
    ActionAddRule<User> actionAddRule() {
        return actionAddRuleBuilder.prefix(PREFIX).build();
    }

    @Bean
    EditAllRule<User> editAllRule() {
        return editAllRuleBuilder.prefix(PREFIX).build();
    }

    @Bean
    ViewAllRule<User> viewAllRule() {
        return viewAllRuleBuilder.prefix(PREFIX).build();
    }
}
