package ru.yandex.partner.jsonapi.crnk.user.authorization.actions;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.actions.UserActionsEnum;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.multistate.UserMultistateGraph;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.AbstractActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionAuthEntry;
import ru.yandex.partner.jsonapi.crnk.user.authorization.actions.check.UserActionCheckName;
import ru.yandex.partner.jsonapi.crnk.user.authorization.actions.check.UserCheckerComposite;
import ru.yandex.partner.jsonapi.models.user.ApiUserModelMetaData;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;

@Component
@ParametersAreNonnullByDefault
public class UserActionsAuthorizationService extends AbstractActionsAuthorizationService<User> {

    private final UserCheckerComposite<User> userCheckerComposite;
    private final Map<String, ActionAuthEntry<User>> authEntryMap;

    @Autowired
    public UserActionsAuthorizationService(UserMultistateGraph graph,
                                           ApiUserModelMetaData apiUserModelMetaData,
                                           AuthenticationFacade authenticationFacade,
                                           UserCheckerComposite<User> userCheckerComposite) {
        super(graph, apiUserModelMetaData, authenticationFacade, userCheckerComposite.getAllRequiredProperties());
        this.userCheckerComposite = userCheckerComposite;
        this.authEntryMap = initMap();
    }

    @Override
    protected Map<String, ActionAuthEntry<User>> getAuthEntryMap() {
        return authEntryMap;
    }

    private Map<String, ActionAuthEntry<User>> initMap() {
        return ActionAuthEntry.buildMap("user_action", List.of(
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.SET_USER_ROLE)
                        .setExposed(true)
                        .setRightRequired(true),
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.REVOKE_ROLES)
                        .setExposed(true)
                        .setRightRequired(true),
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.LINK_ADFOX_USER)
                        .setExposed(true)
                        .setRightRequired(true),
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.UNSUBSCRIBE_FROM_STAT_MONITORING_EMAILS)
                        .setExposed(true)
                        .setRightRequired(false),
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.EDIT)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(List.of(
                                userCheckerComposite.getCheckByName(UserActionCheckName.CAN_EDIT_ALL_OR_IS_CURRENT_USER)
                        )),
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.SET_EXCLUDED_DOMAINS)
                        .setExposed(true)
                        .setRightRequired(false),
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.SET_EXCLUDED_PHONES)
                        .setExposed(true)
                        .setRightRequired(false),
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.SET_BLOCKED)
                        .setExposed(true)
                        .setRightRequired(true),
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.RESET_BLOCKED)
                        .setExposed(true)
                        .setRightRequired(true),
                ActionAuthEntry.<User>builder()
                        .setActionName(UserActionsEnum.CHANGE_CONTRACT)
                        .setExposed(true)
                        .setChecks(List.of(
                                userCheckerComposite.getCheckByName(UserActionCheckName.CAN_CHANGE_CONTRACT)
                        ))
        ));
    }
}
