package ru.yandex.partner.jsonapi.crnk.user.authorization.actions.check;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.user.model.UserWithFeatures;
import ru.yandex.partner.core.feature.UserFeatureEnum;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.libs.auth.model.UserAuthentication;


@Component
@ParametersAreNonnullByDefault
public class CanChangeContractUserChecker<M extends UserWithFeatures> implements ActionChecker<M> {
    @Override
    public <S extends M> List<Boolean> check(UserAuthentication ua,
                                             String modelName, List<S> coreModels) {
        return coreModels.stream()
                .map(UserWithFeatures::getFeatures)
                .map(features ->
                        features != null
                                && features.contains(UserFeatureEnum.EDITABLE_REQUISITES.getFeatureName()))
                .toList();
    }


    @Override
    public List<ModelProperty<? super M, ?>> getRequiredProperties() {
        return List.of(UserWithFeatures.FEATURES);
    }
}
