package ru.yandex.partner.jsonapi.crnk.user.authorization.actions.check;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.jsonapi.crnk.user.UserRightsEnum;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

@ParametersAreNonnullByDefault
@Component
public class CanEditAllOrIsCurrentUserChecker<M extends BaseUser> implements ActionChecker<M> {

    private final IsCurrentUserChecker<M> isCurrentUserChecker;

    @Autowired
    public CanEditAllOrIsCurrentUserChecker(IsCurrentUserChecker<M> isCurrentUserChecker) {
        this.isCurrentUserChecker = isCurrentUserChecker;
    }

    @Override
    public <S extends M> List<Boolean> check(UserAuthentication ua, String modelName, List<S> coreModels) {
        if (ua.userHasRight(UserRightsEnum.EDIT_ALL.getRightName())) {
            return Collections.nCopies(coreModels.size(), true);
        }
        return isCurrentUserChecker.check(ua, modelName, coreModels);
    }

    @Override
    public List<ModelProperty<? super M, ?>> getRequiredProperties() {
        return List.of();
    }
}
