package ru.yandex.partner.jsonapi.crnk.user.authorization.actions.check;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

@ParametersAreNonnullByDefault
@Component
public class IsCurrentUserChecker<M extends BaseUser> implements ActionChecker<M> {
    @Override
    public <S extends M> List<Boolean> check(UserAuthentication ua, String modelName, List<S> coreModels) {
        long uid = ua.getUid();
        return coreModels.stream().map(model -> uid == model.getId()).collect(Collectors.toList());
    }

    @Override
    public List<ModelProperty<? super M, ?>> getRequiredProperties() {
        return List.of();
    }
}
