package ru.yandex.partner.jsonapi.crnk.user.authorization.actions.check;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.jsonapi.crnk.action.check.ActionCheckClassName;

@ParametersAreNonnullByDefault
public enum UserActionCheckName implements ActionCheckClassName {
    IS_CURRENT_USER(IsCurrentUserChecker.class),
    CAN_EDIT_ALL_OR_IS_CURRENT_USER(CanEditAllOrIsCurrentUserChecker.class),
    CAN_CHANGE_CONTRACT(CanChangeContractUserChecker.class);

    private final Class<?> beanClass;

    UserActionCheckName(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public Class<?> getClassName() {
        return beanClass;
    }
}
