package ru.yandex.partner.jsonapi.crnk.user.filter.parser;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.partner.core.entity.user.filter.UserType;
import ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions.IgnorableFilterParserException;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.CrnkFilterValueParser;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.DefaultCrnkFilterValueParser;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;

public class UserTypeCrnkFilterValueParser implements CrnkFilterValueParser<UserType> {

    private final AuthenticationFacade authenticationFacade;
    private final CrnkFilterValueParser<Long> valueParser;

    public UserTypeCrnkFilterValueParser(AuthenticationFacade authenticationFacade) {
        this.authenticationFacade = authenticationFacade;
        this.valueParser = new DefaultCrnkFilterValueParser<>(Long.class);
    }

    @Override
    public List<UserType> toValues(JsonNode node) throws IgnorableFilterParserException {
        Collection<Long> longs = valueParser.toValues(node);

        return UserType.getUserTypes(longs).stream()
                .filter(userType -> userType.getViewRightName() == null
                        || authenticationFacade.userHasRight(userType.getViewRightName()))
                .collect(Collectors.toList());
    }

}
