package ru.yandex.partner.jsonapi.crnk.user.models;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class BalanceContractCrnk {
    @JsonProperty("external_id")
    private String externalId;

    private LocalDate dt;

    @JsonProperty("is_signed")
    private LocalDate isSigned;

    @JsonProperty("is_faxed")
    private LocalDate isFaxed;

    private String status;

    private Integer currency;

    private String vat;

    @JsonProperty("is_oferta1")
    private Integer isOferta1;

    @JsonProperty("is_oferta2")
    private Integer isOferta2;

    @JsonProperty("allows_to_fill_part2")
    private Boolean allowsToFillPart2;

    @JsonProperty("reward_type")
    private Integer rewardType;

    private Integer contractType;

    private Integer firm;

    private Long personId;

    private Integer contract2Id;

    private Integer nds;

    private Integer testMode;

    @JsonGetter("test_mode")
    public String getTestMode() {
        return testMode == null ? null : Long.toString(testMode);
    }

    public void setTestMode(Integer testMode) {
        this.testMode = testMode;
    }

    @JsonGetter("person_id")
    public String getPersonId() {
        return personId == null ? "" : Long.toString(personId);
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    @JsonGetter("contract_type")
    public String getContractType() {
        return contractType == null ? null : Integer.toString(contractType);
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    @JsonGetter("firm")
    public String getFirm() {
        return firm == null ? null : Integer.toString(firm);
    }

    public void setFirm(Integer firm) {
        this.firm = firm;
    }

    @JsonGetter("contract2_id")
    public String getContract2Id() {
        return contract2Id == null ? null : Integer.toString(contract2Id);
    }

    public void setContract2Id(Integer contract2Id) {
        this.contract2Id = contract2Id;
    }

    @JsonGetter("nds")
    public String getNds() {
        return nds == null ? null : Integer.toString(nds);
    }

    public void setNds(Integer nds) {
        this.nds = nds;
    }

    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public LocalDate getDt() {
        return dt;
    }

    public void setDt(LocalDate dt) {
        this.dt = dt;
    }

    @JsonGetter("is_signed")
    public String getIsSigned() {
        return isSigned != null ? DateTimeFormatter.ofPattern("yyyy-MM-dd").format(isSigned) : "";
    }

    public void setIsSigned(LocalDate isSigned) {
        this.isSigned = isSigned;
    }

    @JsonGetter("is_faxed")
    public String getIsFaxed() {
        return isFaxed != null ? DateTimeFormatter.ofPattern("yyyy-MM-dd").format(isFaxed) : "";
    }

    public void setIsFaxed(LocalDate isFaxed) {
        this.isFaxed = isFaxed;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getCurrency() {
        return currency;
    }

    public void setCurrency(Integer currency) {
        this.currency = currency;
    }

    @JsonGetter("currency")
    public String getFormattedCurrency() {
        return currency == null ? null : Integer.toString(currency);
    }

    public String getVat() {
        return vat;
    }

    public void setVat(String vat) {
        this.vat = vat;
    }

    public Integer getIsOferta1() {
        return isOferta1;
    }

    public void setIsOferta1(Integer isOferta1) {
        this.isOferta1 = isOferta1;
    }

    @JsonGetter("is_oferta1")
    public String getFormattedIsOferta1() {
        return isOferta1 == null ? null : Integer.toString(isOferta1);
    }

    public Integer getIsOferta2() {
        return isOferta2;
    }

    public void setIsOferta2(Integer isOferta2) {
        this.isOferta2 = isOferta2;
    }

    @JsonIgnore
    public Boolean getAllowsToFillPart2() {
        return allowsToFillPart2;
    }

    public void setAllowsToFillPart2(Boolean allowsToFillPart2) {
        this.allowsToFillPart2 = allowsToFillPart2;
    }

    @JsonGetter("allows_to_fill_part2")
    public String getFormattedAllowsToFillPart2() {
        return allowsToFillPart2 == null ? null : allowsToFillPart2 ? "1" : "0";
    }

    public Integer getRewardType() {
        return rewardType;
    }

    public void setRewardType(Integer rewardType) {
        this.rewardType = rewardType;
    }

    @JsonGetter("reward_type")
    public String getFormattedRewardType() {
        return rewardType == null ? null : Integer.toString(rewardType);
    }
}
