package ru.yandex.partner.jsonapi.crnk.user.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class BalancePersonCrnk {

    private Long id;

    private Long clientId;

    private String login;

    private String name;

    private String longname;

    private String phone;

    private String email;

    private String fax;

    @JsonProperty("legaladdress")
    private String legalAddress;

    private String representative;

    private String account;

    @JsonProperty("authority_doc_type")
    private String authorityDocType;

    @JsonProperty("ben_account")
    private String benAccount;

    @JsonProperty("ben_bank")
    private String benBank;

    private String bik;

    private String iban;

    private String inn;

    private String kpp;

    private String other;

    @JsonProperty("person_account")
    private String personAccount;

    @JsonProperty("postaddress")
    private String postAddress;

    @JsonProperty("signer_person_name")
    private String signerPersonName;

    @JsonProperty("signer_position_name")
    private String signerPositionName;

    private String swift;

    @JsonProperty("yamoney_wallet")
    private String yamoneyWallet;

    private BalanceBankCrnk bank;

    @JsonProperty("payoneer_wallet")
    private String payoneerWallet;

    @JsonProperty("type")
    private String type;

    @JsonGetter("id")
    public String getId() {
        return id == null ? null : Long.toString(id);
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonGetter("client_id")
    public String getClientId() {
        return clientId == null ? null : Long.toString(clientId);
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLongname() {
        return longname;
    }

    public void setLongname(String longname) {
        this.longname = longname;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getLegalAddress() {
        return legalAddress;
    }

    public void setLegalAddress(String legalAddress) {
        this.legalAddress = legalAddress;
    }

    public String getRepresentative() {
        return representative;
    }

    public void setRepresentative(String representative) {
        this.representative = representative;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAuthorityDocType() {
        return authorityDocType;
    }

    public void setAuthorityDocType(String authorityDocType) {
        this.authorityDocType = authorityDocType;
    }

    public String getBenAccount() {
        return benAccount;
    }

    public void setBenAccount(String benAccount) {
        this.benAccount = benAccount;
    }

    public String getBenBank() {
        return benBank;
    }

    public void setBenBank(String benBank) {
        this.benBank = benBank;
    }

    public String getBik() {
        return bik;
    }

    public void setBik(String bik) {
        this.bik = bik;
    }

    public String getIban() {
        return iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public String getInn() {
        return inn;
    }

    public void setInn(String inn) {
        this.inn = inn;
    }

    public String getKpp() {
        return kpp;
    }

    public void setKpp(String kpp) {
        this.kpp = kpp;
    }

    public String getOther() {
        return other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public String getPersonAccount() {
        return personAccount;
    }

    public void setPersonAccount(String personAccount) {
        this.personAccount = personAccount;
    }

    public String getPostAddress() {
        return postAddress;
    }

    public void setPostAddress(String postAddress) {
        this.postAddress = postAddress;
    }

    public String getSignerPersonName() {
        return signerPersonName;
    }

    public void setSignerPersonName(String signerPersonName) {
        this.signerPersonName = signerPersonName;
    }

    public String getSignerPositionName() {
        return signerPositionName;
    }

    public void setSignerPositionName(String signerPositionName) {
        this.signerPositionName = signerPositionName;
    }

    public String getSwift() {
        return swift;
    }

    public void setSwift(String swift) {
        this.swift = swift;
    }

    public String getYamoneyWallet() {
        return yamoneyWallet;
    }

    public void setYamoneyWallet(String yamoneyWallet) {
        this.yamoneyWallet = yamoneyWallet;
    }

    public Object getBank() {
        if (id == 0 && clientId == 0 && bank == null) {
            return null;
        }
        return bank == null ? new String() : bank;
    }

    public void setBank(BalanceBankCrnk bank) {
        this.bank = bank;
    }

    public String getPayoneerWallet() {
        return payoneerWallet;
    }

    public String getType() {
        return type;
    }

    public void setPayoneerWallet(String payoneerWallet) {
        this.payoneerWallet = payoneerWallet;
    }

    public void setType(String type) {
        this.type = type;
    }
}
