package ru.yandex.partner.jsonapi.crnk.user.models;

import java.util.List;
import java.util.Optional;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.jsonapi.crnk.user.UserCrnkJsonFieldAliases;


@SuppressWarnings("unused")
public class PageOwnerCrnk {
    @JsonProperty(UserCrnkJsonFieldAliases.ID)
    private Long id;

    @JsonProperty(UserCrnkJsonFieldAliases.LOGIN)
    private String login;

    @JsonProperty(UserCrnkJsonFieldAliases.NAME)
    private String name;

    @JsonProperty(UserCrnkJsonFieldAliases.LAST_NAME)
    private String lastname;

    @JsonProperty(UserCrnkJsonFieldAliases.MID_NAME)
    private String midname;

    @JsonProperty(UserCrnkJsonFieldAliases.EMAIL)
    private String email;

    @JsonProperty(UserCrnkJsonFieldAliases.CLIENT_ID)
    private Long clientId;

    @JsonProperty(UserCrnkJsonFieldAliases.ROLES)
    private Set<RoleCrnk> roles;

    @JsonProperty(UserCrnkJsonFieldAliases.FEATURES)
    private List<String> features;

    @JsonProperty(UserCrnkJsonFieldAliases.IS_ASSESSOR)
    private Boolean isAssessor;

    @JsonProperty(UserCrnkJsonFieldAliases.IS_TUTBY)
    private Boolean isTutby;

    @JsonProperty(UserCrnkJsonFieldAliases.BUSINESS_UNIT)
    private Boolean businessUnit;

    @JsonProperty(UserCrnkJsonFieldAliases.CURRENT_CURRENCY)
    private String currentCurrency;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLastname() {
        return lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getMidname() {
        return midname;
    }

    public void setMidname(String midname) {
        this.midname = midname;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public Set<RoleCrnk> getRoles() {
        return roles;
    }

    public void setRoles(Set<RoleCrnk> roles) {
        this.roles = roles;
    }

    public List<String> getFeatures() {
        return features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public Boolean getIsAssessor() {
        return isAssessor;
    }

    public void setIsAssessor(Boolean assessor) {
        isAssessor = assessor;
    }

    public Boolean getIsTutby() {
        return isTutby;
    }

    public void setIsTutby(Boolean tutby) {
        isTutby = tutby;
    }

    public Boolean getBusinessUnit() {
        return businessUnit;
    }

    public void setBusinessUnit(Boolean businessUnit) {
        this.businessUnit = businessUnit;
    }

    public String getCurrentCurrency() {
        return currentCurrency;
    }

    /**
     * отдаем в апишку default значение, если в модели null
     * @param currentCurrency
     */
    public void setCurrentCurrency(String currentCurrency) {
        this.currentCurrency = Optional.ofNullable(currentCurrency)
                .orElse(CoreConstants.Currency.DEFAULT);
    }
}
