package ru.yandex.partner.jsonapi.crnk.user.models;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class RoleCrnk {
    @JsonProperty("id")
    private long roleId;

    private String name;

    @JsonProperty("is_internal")
    private Boolean internal;

    @JsonProperty("related_page_accessor")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private SortedSet<String> relatedPageAccessor;

    private Boolean viewer;

    @JsonProperty("assessor_applicable")
    @JsonFormat(shape = JsonFormat.Shape.NUMBER)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Boolean assessorApplicable;

    private long group;

    @JsonProperty("conflict_role_for_set")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private List<Long> conflictRoleForSet;

    @JsonProperty("required_role_for_set")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private List<Long> requiredRoleForSet;

    @JsonProperty("all_external")
    @JsonFormat(shape = JsonFormat.Shape.NUMBER)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Boolean allExternal;

    public long getRoleId() {
        return roleId;
    }

    public void setRoleId(long roleId) {
        this.roleId = roleId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getInternal() {
        return internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    public Set<String> getRelatedPageAccessor() {
        return relatedPageAccessor;
    }

    public void setRelatedPageAccessor(SortedSet<String> relatedPageAccessor) {
        this.relatedPageAccessor = relatedPageAccessor;
    }

    public Boolean getViewer() {
        return viewer;
    }

    public void setViewer(Boolean viewer) {
        this.viewer = viewer;
    }

    public Boolean getAssessorApplicable() {
        return assessorApplicable;
    }

    public void setAssessorApplicable(Boolean assessorApplicable) {
        this.assessorApplicable = assessorApplicable;
    }

    public long getGroup() {
        return group;
    }

    public void setGroup(long group) {
        this.group = group;
    }

    public List<Long> getConflictRoleForSet() {
        return conflictRoleForSet;
    }

    public void setConflictRoleForSet(List<Long> conflictRoleForSet) {
        this.conflictRoleForSet = conflictRoleForSet;
    }

    public List<Long> getRequiredRoleForSet() {
        return requiredRoleForSet;
    }

    public void setRequiredRoleForSet(List<Long> requiredRoleForSet) {
        this.requiredRoleForSet = requiredRoleForSet;
    }

    public Boolean getAllExternal() {
        return allExternal;
    }

    public void setAllExternal(Boolean allExternal) {
        this.allExternal = allExternal;
    }
}
