package ru.yandex.partner.jsonapi.filter.action;

import java.io.IOException;
import java.util.Set;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jetbrains.annotations.NotNull;
import org.springframework.web.filter.OncePerRequestFilter;

import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;

public class ActionUserIdSettingFilter extends OncePerRequestFilter {

    private final ActionUserIdContext actionUserIdContext;
    private final AuthenticationFacade authenticationFacade;

    // http методы, в которых может быть завязанная на экшенах логика
    private static final Set<String> RELATED_HTTP_METHODS = Set.of("POST", "PATCH");

    public ActionUserIdSettingFilter(ActionUserIdContext actionUserIdContext,
                                     AuthenticationFacade authenticationFacade) {
        this.actionUserIdContext = actionUserIdContext;
        this.authenticationFacade = authenticationFacade;
    }

    @Override
    protected void doFilterInternal(@NotNull HttpServletRequest request,
                                    @NotNull HttpServletResponse response,
                                    @NotNull FilterChain filterChain) throws ServletException, IOException {
        if (!RELATED_HTTP_METHODS.contains(request.getMethod())) {
            filterChain.doFilter(request, response);
            return;
        }
        try {
            if (authenticationFacade.getUserAuthentication() != null) {
                actionUserIdContext.setUserId(authenticationFacade.getUserAuthentication().getUid());
            }
            filterChain.doFilter(request, response);
        } finally {
            actionUserIdContext.setDefault();
        }
    }
}
