package ru.yandex.partner.jsonapi.filter.locale;

import java.io.IOException;

import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.LocaleResolver;

public class LocaleResolverFilter extends OncePerRequestFilter {
    private final LocaleResolver localeResolver;

    public LocaleResolverFilter(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Override
    protected void doFilterInternal(
            @Nonnull HttpServletRequest request,
            @Nonnull HttpServletResponse response,
            @Nonnull FilterChain filterChain) throws ServletException, IOException {
        // делаем ручками так как фильтр spring-а отрабатывает позже фильтра crnk-а
        LocaleContextHolder.setLocale(localeResolver.resolveLocale(request));
        filterChain.doFilter(request, response);
    }
}
