package ru.yandex.partner.jsonapi.filter.logging;

import java.io.IOException;

import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.MDC;
import org.springframework.web.filter.OncePerRequestFilter;

import ru.yandex.partner.defaultconfiguration.logging.ErrorBoosterMessageConverter;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

public class LoggingFilter extends OncePerRequestFilter {

    private final AuthenticationFacade authenticationFacade;

    public LoggingFilter(AuthenticationFacade authenticationFacade) {
        this.authenticationFacade = authenticationFacade;
    }

    @Override
    protected void doFilterInternal(@Nonnull HttpServletRequest request,
                                    @Nonnull HttpServletResponse response,
                                    @Nonnull FilterChain filterChain) throws ServletException, IOException {
        UserAuthentication authentication = authenticationFacade.getUserAuthentication();
        if (authentication != null) {
            MDC.put(ErrorBoosterMessageConverter.MDCKeys.YANDEX_UID,
                    "" + authenticationFacade.getUserAuthentication().getUid());
            MDC.put(ErrorBoosterMessageConverter.MDCKeys.YANDEX_LOGIN, authentication.getLogin());
        }
        MDC.put(ErrorBoosterMessageConverter.MDCKeys.REQUEST_PATH, request.getServletPath());
        MDC.put(ErrorBoosterMessageConverter.MDCKeys.REQUEST_METHOD, request.getMethod());

        try {
            filterChain.doFilter(request, response);
        } finally {
            MDC.clear();
        }
    }
}
