package ru.yandex.partner.jsonapi.jackson;

import com.fasterxml.jackson.core.JsonStreamContext;
import org.apache.commons.lang3.StringUtils;

public class DeserializationExceptionData {
    private static final String[] EMPTY_PATH = new String[0];
    private final String[] path;
    private final Class<?> targetClass;
    private final Object valueToConvert;

    public DeserializationExceptionData(JsonStreamContext jsonStreamContext,
                                        Class<?> targetClass,
                                        Object valueToConvert) {
        this.targetClass = targetClass;
        this.valueToConvert = valueToConvert;

        String strPath = StringUtils.strip(jsonStreamContext.pathAsPointer().toString(), "/");
        if (strPath.isEmpty()) {
            this.path = EMPTY_PATH;
        } else {
            this.path = strPath.split("/");
        }
    }

    public String[] getPath() {
        return path;
    }

    public Class<?> getTargetClass() {
        return targetClass;
    }

    public Object getValueToConvert() {
        return valueToConvert;
    }
}
