package ru.yandex.partner.jsonapi.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum CommonMsg implements GettextMsg {
    UNKNOWN_FIELDS(msg("Unknown fields: %s"), "lib__Application__Model__Product__AN__ContextOnSite__Direct.pm"),
    DATA_MUST_BE_HASH(msg("Data must be HASH"), "lib__QBit__Validator.pm"),
    DATA_MUST_BE_ARRAY(msg("Data must be ARRAY"), "lib__QBit__Validator.pm"),
    DATA_MUST_BE_BOOLEAN(msg("Expected type boolean"), "lib__QBit__Validator__Type__boolean.pm"),
    DATA_MUST_BE_NUMBER(msg("Data must be numeric, but got \"%s\""), "lib__QBit__Validator__Type__scalar.pm"),
    DATA_MUST_BE_STRING(msg("Data must be STRING"), "lib__QBit__Validator.pm"),
    INCORRECT_JSON(msg("Incorrect json"), "lib__QBit__Validator__Type__json.pm"),
    INCORRECT_ID(msg("Incorrect id: %s"), "lib__RestApi__Controller.pm");


    private final GettextMsgPayload payload;
    private final String keysetName;

    CommonMsg(GettextMsgPayload.Builder builder, String keysetName) {
        this.payload = builder.build();
        this.keysetName = keysetName;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keysetName;
    }
}
