package ru.yandex.partner.jsonapi.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum ControllerMsg implements GettextMsg {
    PARAMETER_PAGE_SIZE_EXCEEDED(msg("Parameter page[size] must be <= %s")),
    SUBFILTERS_USE_ARRAY_OR_SCALAR(msg("In subfilters use array or a scalar")),
    PARAMETER_FILTER_INCORRECT(msg("Parameter \"filter\" incorrect"));

    private static final String KEYSET_NAME = "lib__RestApi__Controller.pm";
    private final GettextMsgPayload payload;

    ControllerMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }


    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
