package ru.yandex.partner.jsonapi.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum FilterMsg implements GettextMsg {
    BAD_OPERATOR_IN_FILTER(msg("Bad operator \"%s\" for \"%s\" (type: %s) in filter")),
    INCORRECT_DATA_FOR_FILTER(msg("Incorrect data for filter by field \"%s\" (type: %s)"));

    private final GettextMsgPayload payload;

    FilterMsg(GettextMsgPayload.Builder builder) {
        payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return "lib__QBit__Application__Model__DBManager__Filter__period.pm";
    }
}
