package ru.yandex.partner.jsonapi.messages;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum JacksonDataValidationMsg implements GettextMsg {

    EXPECTED_ID(msg("Expected \\\"id\\\"")),
    EXPECTED_TYPE(msg("Expected \\\"type\\\"")),
    INCORRECT_ID(msg("Incorrect id")),
    INCORRECT_TYPE(msg("Type does not match resource"));

    private static final String KEYSET_NAME = "lib__RestApi__Controller__Product.pm";

    private final GettextMsgPayload payload;

    JacksonDataValidationMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
