package ru.yandex.partner.jsonapi.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum JsonApiModelMsg implements GettextMsg {
    UNEXPECTED_FIELDS(msg("Unexpected fields: %s"));

    private static final String KEYSET_NAME = "lib__RestApi__Model.pm";
    private final GettextMsgPayload payload;

    JsonApiModelMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }


    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
