package ru.yandex.partner.jsonapi.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum MethodMsg implements GettextMsg {
    PARAMETER_MUST_BE_WHOLE_POSITIVE_NUMBER(msg("Parameter '%s' must be a whole positive number."));

    private static final String KEYSET_NAME = "lib__API__Method.pm";
    private final GettextMsgPayload payload;

    MethodMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }


    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
