package ru.yandex.partner.jsonapi.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum PersonMsg implements GettextMsg {
    EMAIL(msg("E-Mail")),
    PHONE(msg("Phone")),
    ACCOUNTANT_EMAIL(msg("Accountant E-Mail"));

    private static final String KEYSET_NAME = "lib__Application__Model__Person.pm";
    private final GettextMsgPayload payload;

    PersonMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
