package ru.yandex.partner.jsonapi.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum RestApiMsg implements GettextMsg {
    ALLOWED_REQUEST_PER_MINUTE(msg("Allowed %s requests for minute")),
    INCORRECT_CSRF_TOKEN(msg("Incorrect csrf token"));

    private static final String KEYSET_NAME = "lib__RestApi.pm";
    private final GettextMsgPayload payload;


    RestApiMsg(GettextMsgPayload.Builder builder) {
        payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
