package ru.yandex.partner.jsonapi.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum StrategyMsg implements GettextMsg {
    MAXIMUM_REVENUE(msg("Maximum revenue")),
    MINIMUM_CPM(msg("Minimum CPM")),
    SEPARATE_CPM(msg("Separate CPM"));

    private final GettextMsgPayload payload;
    private final String keyset;

    StrategyMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
        this.keyset = "lib__Application__Model__ExternalBlock.pm";
    }


    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
