package ru.yandex.partner.jsonapi.messages.block;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum BlockMsg implements GettextMsg {
    DOMAIN_AND_MIRROR(msg("Domain and mirror"),
            "lib__Application__Model__Product__InternalAN__InternalSearchOnSite__Premium.pm"),
    MANAGER_LOGIN(msg("Manager's login"), "lib__Application__Model__Inviter.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    BlockMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    BlockMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
