package ru.yandex.partner.jsonapi.messages.block;

import javax.annotation.Nonnull;

import ru.yandex.partner.jsonapi.messages.StrategyMsg;
import ru.yandex.partner.jsonapi.messages.user.UserMsg;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum RtbMsg implements GettextMsg {
    BLOCK_ID(msg("Block ID"), "lib__Application__Model__Statistics__Payment__AdvNet__MobileApp__RTB.pm"),
    BLOCKS_CAPTION_ID(msg("Block's caption"), "lib__Application__Model__Product__VideoAN__Site__Video.pm"),
    PAGE_ID(msg("Page ID"), "lib__Application__Model__Statistics__Product.pm"),
    ADFOX_BLOCK(msg("ADFOX block"), "lib__Application__Model__Statistics__Payment__AdvNetVideo__InStream.pm"),
    SITE_VERSION(msg("Site version"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    STRATEGY(msg("Strategy"), "lib__Application__Model__Product__AN__MobileApp__RTB.pm"),
    MINIMUM_CPM(StrategyMsg.MINIMUM_CPM),
    TEXT_CPM(msg("Text CPM"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    TEXT_BLOCKED(msg("Text blocked"), "lib__Application__Model__Role__Has__Strategies.pm"),
    MEDIA_CPM(msg("Media CPM"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    MEDIA_BLOCKED(msg("Media blocked"), "lib__Application__Model__Role__Has__Strategies.pm"),
    VIDEO_CPM(msg("Video CPM"), "lib__Application__Model__Role__Has__Strategies__WithFilters.pm"),
    VIDEO_BLOCKED(msg("Video blocked"), "lib__Application__Model__Role__Has__Strategies__WithFilters.pm"),
    LOGIN(UserMsg.LOGIN),
    USER_TYPE(UserMsg.USER_TYPE),
    CLIENT_ID(UserMsg.CLIENT_ID),
    STATUS(UserMsg.STATUS),
    PLACE_ID(msg("Place ID"), "lib__Application__Model__Role__Has__PlaceID.pm"),
    IS_MOBILE_MEDIATION(msg("Is Mobile Mediation"), "lib__Application__Model__Role__Has__IsMobileMediation.pm"),
    BLOCK_TYPE(msg("Mobile block type"), "lib__Application__Model__Product__AN__MobileApp__RTB.pm"),
    APP_ID(msg("App ID"), "lib__Application__Model__Statistics__Payment__AdvNet__MobileApp.pm"),
    STORE_ID(msg("Store ID"), "lib__Application__Model__Statistics__Payment__AdvNet__MobileApp__RTB.pm"),
    PLATFORM(msg("Platform"), "lib__Application__Model__Statistics__MobileMediation.pm"),
    ANDROID(msg("Android"), "lib__Application__Model__Product__AN__MobileApp.pm"),
    IOS(msg("iOS"), "lib__Application__Model__Product__AN__MobileApp.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    RtbMsg(GettextMsg gettextMsg) {
        this(gettextMsg.getPayload(), gettextMsg.getKeysetName());
    }

    RtbMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    RtbMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
