package ru.yandex.partner.jsonapi.messages.user;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum UserMsg implements GettextMsg {
    ROLE(msg("Role")),
    LOGIN(msg("Login")),
    USER_TYPE(msg("User type")),
    CLIENT_ID(msg("Client ID")),
    CLIENT_ID_HINT(msg("The unique identifier of a partner in Balance")),
    CONTRACT_ID(msg("Contract ID")),
    LAST_NAME(msg("Lastname")),
    NAME(msg("Name")),
    STATUS(msg("Status")),
    ADFOX_ID(msg("AdFox ID")),
    HAS_BUSINESS_RULES(msg("Is user has business rules")),
    DOMAIN_LOGIN(msg("Domain login")),
    INDIVIDUAL_ENTREPRENEUR(msg("individual_entrepreneur")),
    INDIVIDUAL(msg("individual")),
    SELFEMPLOYED(msg("selfemployed")),
    ENTITY(msg("entity"));

    private static final String KEYSET_NAME = "lib__Application__Model__Users.pm";
    private final GettextMsgPayload payload;

    UserMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
