package ru.yandex.partner.jsonapi.models;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.result.PathNodeConverterProvider;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.relationships.ApiRelationship;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public interface ApiModel<M extends ModelWithId> extends ApiModelPart<M>, ApiModelMetaData<M> {
    Class<M> getModelClass();

    String getResourceType();

    M createNewInstance();

    Policy<M> getPolicy();

    MetaFilter<? super M, Long> getIdFilter();

    Map<String, Map<String, String>> getRelationshipsLinks();

    ApiFieldsAccessRulesService<M> getApiFieldsAvailableRules();

    ApiFieldsAccessRulesService<EditableData<M>> getApiFieldsEditableRules();

    @Nullable
    default PathNodeConverterProvider getPathNodeConverterProvider() {
        return null;
    }

    default List<ApiRelationship<M>> getApiRelationships() {
        return List.of();
    }

    default Map<String, ApiField<M>> getApiFieldMap() {
        return getFields().stream()
                .map(apiField -> Map.entry(apiField.getJsonName(), apiField))
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}
