package ru.yandex.partner.jsonapi.models;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.validation.CovariantPathNodeConverterProvider;

@ParametersAreNonnullByDefault
public interface ApiModelPart<M extends Model> extends PathNodeConverterConfigurer {
    List<ApiField<M>> getFields();

    default Map<String, CrnkFilter<M, ?>> getFilters() {
        return Map.of();
    }

    default Optional<DependsHolder> getDepends() {
        return Optional.empty();
    }

    @Override
    default void configurePathNodeConverter(CovariantPathNodeConverterProvider.Builder builder) {
        // TODO looks hacky!
        getFields().stream()
                .filter(ApiField::hasCoreValue)
                .forEach(apiField -> {
                    ModelProperty<?, ?> prop = apiField.getModelPath().lastProperty();

                    builder.converterForClass(
                            prop.getModelClass(),
                            converterConfig -> converterConfig.replace(prop, apiField.getJsonName())
                    );
                });
    }
}
