package ru.yandex.partner.jsonapi.models;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.entity.LimitOffset;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.partner.core.action.factories.ActionFactory;
import ru.yandex.partner.core.utils.OrderBy;
import ru.yandex.partner.jsonapi.crnk.BaseCrnkMetaInformation;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.IncomingApiFields;
import ru.yandex.partner.jsonapi.crnk.filter.parser.FilterNode;
import ru.yandex.partner.jsonapi.models.relationships.ApiRelationship;

public interface ApiService<M extends ModelWithId> {
    M findOne(Long id, Set<ModelProperty<? extends Model, ?>> modelProperties);

    List<M> findAll(Set<ModelProperty<? extends Model, ?>> modelProperties,
                    @Nullable FilterNode filterNode,
                    @Nullable LimitOffset limitOffset,
                    @Nullable List<OrderBy> orderByList);

    long count(@Nullable FilterNode filterNode);

    M save(M model, IncomingApiFields<M> updatedFields, List<DefectInfo<Defect>> parseDefectInfos);

    M create(M model, IncomingApiFields<M> updatedFields, List<DefectInfo<Defect>> parseDefectInfos);

    @Nullable
    ActionFactory<M, ?> getActionFactory(String actionName);

    /**
     * Выполнение экшена actionName с пейлоадом, структура которого соответствует структуре модели
     *
     * @param actionName        название экшена
     * @param model             пейлоад модели
     * @param incomingApiFields информация о полях, которые пришли в пейлоаде
     * @param parseDefectInfos  информация о выявленных дефектах в результате парсинга в структуру модели
     */
    M doAction(String actionName,
               M model,
               IncomingApiFields<M> incomingApiFields,
               List<DefectInfo<Defect>> parseDefectInfos);

    /**
     * Выполнение экшена с кастомным пейлоадом, структура которого диктуется особенностями работы соотв. экшена
     *
     * @param actionName название экшена
     * @param modelRef   часть пейлоада модели, по которой можно идентифицировать модель
     * @param payload    кастомный пейлоад экшена (определяется особенностями экшена)
     */
    M doAction(String actionName,
               M modelRef,
               JsonNode payload);

    ApiModel<M> getApiModel();

    ApiFieldsService<M> getApiFieldsService();

    String coreIdToApiId(Long id);

    Long apiIdToCoreId(String id);

    boolean apiCanAdd();

    boolean needToSetSelfLink();

    List<ApiRelationship<M>> getApiRelationships();

    @Nullable
    ApiRelationship<M> getApiRelationships(String fieldName);

    default void fillMetaInformation(BaseCrnkMetaInformation baseCrnkMetaInformation) {
    }
}
