package ru.yandex.partner.jsonapi.models;

import java.util.EnumMap;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;

@ParametersAreNonnullByDefault
public class CommonFunctionComposite<T extends Model> implements AccessFunctionComposite<T> {
    private final EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<T>> availableFunctions;
    private final EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<EditableData<T>>> editableFunctions;

    public CommonFunctionComposite() {
        this.availableFunctions = new EnumMap<>(FunctionNameEnum.class);
        this.editableFunctions = new EnumMap<>(FunctionNameEnum.class);
        initMap(availableFunctions, editableFunctions);
    }

    protected void initMap(
            EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<T>> availableFunctions,
            EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<EditableData<T>>> editableFunctions) {
    }

    protected Map<FunctionNameEnum, ApiFieldsAccessRulesFunction<T>> getAvailableFunctions() {
        return availableFunctions;
    }

    @Override
    public ApiFieldsAccessRulesFunction<T> getAvailableFunction(FunctionNameEnum functionName) {
        if (!availableFunctions.containsKey(functionName)) {
            throw new IllegalArgumentException(
                    String.format("Function %s doesn't exist in Composite class", functionName));
        }

        return availableFunctions.get(functionName);
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<T>> getEditableFunction(FunctionNameEnum functionName) {
        if (!editableFunctions.containsKey(functionName)) {
            throw new IllegalArgumentException(
                    String.format("Function %s doesn't exist in Composite class", functionName));
        }

        return editableFunctions.get(functionName);
    }
}
