package ru.yandex.partner.jsonapi.models;

import java.util.List;
import java.util.Map;

public class DependsHolder {

    public static final String DEPENDS = "depends";
    public static final String REQUIRED = "required";

    private Map<String, List<String>> depends;
    private Map<String, List<String>> required;

    public DependsHolder(Map<String, List<String>> depends, Map<String, List<String>> required) {
        this.depends = depends != null ? depends : Map.of();
        this.required = required != null ? required : Map.of();
    }

    public DependsHolder(Map<String, Map<String, List<String>>> map) {
        this(map.get(DEPENDS), map.get(REQUIRED));
    }

    public DependsHolder() {
        this(Map.of(), Map.of());
    }

    public Map<String, Map<String, List<String>>> toMap() {
        return Map.of(DEPENDS, depends, REQUIRED, required);
    }

    public Map<String, List<String>> getDepends() {
        return depends;
    }

    public Map<String, List<String>> getRequired() {
        return required;
    }
}
