package ru.yandex.partner.jsonapi.models;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;

public class ModelClassUtils {

    private ModelClassUtils() {
        // just utils
    }

    public static <T> ParametrizedJavaTypeHolder<List<T>> getListClass(Class<T> parameterType) {
        return new ParametrizedJavaTypeHolder<>(TypeFactory.defaultInstance().constructParametricType(List.class,
                parameterType));
    }

    public static JavaType valType(Class<?> parameterType) {
        return TypeFactory.defaultInstance().constructType(parameterType);
    }

    public static <T> ParametrizedJavaTypeHolder<Set<T>> getSetClass(Class<T> parameterType) {
        return new ParametrizedJavaTypeHolder<>(TypeFactory.defaultInstance().constructParametricType(Set.class,
                parameterType));
    }

    public static <K, V> ParametrizedJavaTypeHolder<Map<K, V>> getMapClass(Class<?> keyType, Class<?> valueType) {
        return new ParametrizedJavaTypeHolder<>(TypeFactory.defaultInstance().constructParametricType(Map.class,
                keyType, valueType));
    }
}
